!    XCASCADE software implements Monte Carlo approach to model electron cascades in solids induced by X-ray impact or by an impact of high-energy electrons
!    Copyright (C) 2025 Deutsches Elektronen-Synchrotron DESY, a research centre of the Helmholtz Association.

!    This file is part of XCASCADE software.

!    Authors:
!    Vladimir Lipp <vladimir.lipp@desy.de> (DESY)
!    Nikita Medvedev <medvedev@ipp.cas.cz> (DESY)
!    Beata Ziaja <ziaja@mail.desy.de> (DESY & IFJ)

!    SPDX-FileCopyrightText: 2025 Deutsches Elektronen-Synchrotron DESY
!    SPDX-License-Identifier: AGPL-3.0-only

!    XCASCADE is free software: you can redistribute it and/or modify it under the terms of the Affero GNU General Public License version 3 only, as published by the Free Software Foundation.
!    XCASCADE is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Affero GNU General Public License version 3 for more details.
!    You should have received a copy of the Affero GNU General Public License version 3 along with XCASCADE. If not, see <https://www.gnu.org/licenses/>.

!    For more information about this software, see https://doi.org/10.5281/zenodo.8204314 and https://xm.cfel.de/research/scientific_software/xcascade_amp_xcascade_3d/.

! This module contains all the global variables, physical constants and parameters
MODULE Constants
 implicit none

real(8) g_Pi, g_e, g_me, g_cvel, g_Mp, g_h, g_kb, g_e0, g_mu0, g_Ry, g_a0, g_v0, g_alpha   ! universal constants 

!UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
! Universal constants:
parameter (g_Pi = 3.1415926535897932384626433832795d0)            ! Pi
parameter (g_e = 1.602176487d-19)         ! Electron charge       [Coulomb]
parameter (g_me = 9.1093821545d-31)       ! Electron mass         [kg]
parameter (g_cvel = 299792458.0d0)        ! Light velosity        [m/sec]
parameter (g_Mp =1836.1526724780d0*g_me)    ! Proton mass           [kg]
parameter (g_h = 1.05457162853d-34)       ! Plank constant        [J*sec]
parameter (g_kb = 11604.0d0)              ! Boltzmann constant    [K/eV]
parameter (g_e0 = 8.854187817620d-12)     ! Electrical constant   [F/m]
parameter (g_mu0 = 1.2566370614359d-6)    ! Magnetic constant     [H*A^-2]
parameter (g_Ry = 13.606d0)               ! Rydberg constant      [eV]
parameter (g_a0 = 0.5291772085936d0)      ! Bohr radius           [A]
parameter (g_v0 = sqrt(2.0d0*g_Ry*g_e/g_me))    ! Bohr velosity         [m/s]
parameter (g_alpha = g_e*g_e/(g_h*g_cvel*4.0d0*g_Pi*g_e0))    ! Fine structure constant
!UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU

END MODULE Constants 