#! /bin/bash
#    XCASCADE-3D software implements Monte Carlo approach to model electron cascades in solids induced by X-ray impact or by an impact of high-energy electrons
#    Copyright (C) 2025 Deutsches Elektronen-Synchrotron DESY, a research centre of the Helmholtz Association.

#    This file is part of XCASCADE-3D software.

#    Authors:
#    Vladimir Lipp <vladimir.lipp@desy.de> (DESY)
#    Nikita Medvedev <medvedev@ipp.cas.cz> (DESY)
#    Beata Ziaja <ziaja@mail.desy.de> (DESY & IFJ)
#    SPDX-License-Identifier: AGPL-3.0-only

#    XCASCADE-3D is free software: you can redistribute it and/or modify it under the terms of the Affero GNU General Public License version 3 only, as published by the Free Software Foundation.
#    XCASCADE-3D is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Affero GNU General Public License version 3 for more details.
#    You should have received a copy of the Affero GNU General Public License version 3 along with XCASCADE-3D. If not, see <https://www.gnu.org/licenses/>.

#    For more information about this software, see https://doi.org/10.5281/zenodo.8204314 and https://xm.cfel.de/research/scientific_software/xcascade_amp_xcascade_3d/.


# This is a script to execute after a successful XCASCADE-3D run. It will automatically create plots from the output files using gnuplot scripts provided in this folder. It requires gnuplot to be installed in the system. See the manual for description of the output files.

cd ./plots


if [ -e ../OUTPUTs/OUTPUT_events2d.dat ] # if the data-file exists
then # plot it
	{ echo 'plot Events2d';
	gnuplot plot_events2d.gpi;  }
	{ convert -density 300 +antialias Events2d.eps Events2d.png;
	rm Events2d.eps; }&  # here, we do not wait until 'convert' finishes; we start plotting next file in parallel
else # else remove old plot if it exists
	if [ -e Events2d.png ]; then rm Events2d.png -v; fi;
fi


if [ -e ../OUTPUTs/OUTPUT_Z_dependence.dat ]
then
	{ echo 'plot Z_eE';
	gnuplot plot_Z_eE.gpi; }
	{ convert -density 300 +antialias Z_eE.eps Z_eE.png;
	rm Z_eE.eps; } &

	{ echo 'plot Z_eN';
	gnuplot plot_z_eN.gpi; }
	{ convert -density 300 +antialias Z_eN.eps Z_eN.png;
	rm Z_eN.eps; } &
else
	if [ -e Z_eN.png ]; then rm Z_eN.png -v; fi;
	if [ -e Z_eE.png ]; then rm Z_eE.png -v; fi;
fi


if [ -e ../OUTPUTs/OUTPUT_Z_dependence_holes.dat ]
then
	{ echo 'plot Z_hE';
	gnuplot plot_Z_hE.gpi; } 
	{ convert -density 300 +antialias Z_hE.eps Z_hE.png;
	rm Z_hE.eps; }&
	
	{ echo 'plot Z_hN';
	gnuplot plot_z_hN.gpi; } 
	{ convert -density 300 +antialias Z_hN.eps Z_hN.png;
	rm Z_hN.eps; }& 
else
	if [ -e Z_hN.png ]; then rm Z_hN.png -v; fi;
	if [ -e Z_hE.png ]; then rm Z_hE.png -v; fi;
fi


if [ -e ../OUTPUTs/OUTPUT_spherical.dat ]
then
	{ echo 'plot Spherical_eE';
	gnuplot plot_spherical_eE.gpi; }
	{ convert -density 300 +antialias Spherical_eE.eps Spherical_eE.png;
	rm Spherical_eE.eps; }&
	
	{ echo 'plot Spherical_eN';
	gnuplot plot_spherical_eN.gpi; }
	{ convert -density 300 +antialias Spherical_eN.eps Spherical_eN.png;
	rm Spherical_eN.eps; }&
else
	if [ -e Spherical_eN.png ]; then rm Spherical_eN.png -v; fi;
	if [ -e Spherical_eE.png ]; then rm Spherical_eE.png -v; fi;
fi


if [ -e ../OUTPUTs/OUTPUT_cylindrical.dat ]
then
	echo 'plot Cylindrical_eE';
	{ gnuplot plot_cylindrical_eE.gpi;
	convert -density 300 +antialias Cylindrical_eE.eps Cylindrical_eE.png;
	rm Cylindrical_eE.eps; } 
	
	{ echo 'plot Cylindrical_eN';
	gnuplot plot_cylindrical_eN.gpi; }
	{ convert -density 300 +antialias Cylindrical_eN.eps Cylindrical_eN.png;
	rm Cylindrical_eN.eps; }&
else
	if [ -e Cylindrical_eN.png ]; then rm Cylindrical_eN.png -v; fi;
	if [ -e Cylindrical_eE.png ]; then rm Cylindrical_eE.png -v; fi;
fi


if [ -e ../OUTPUTs/OUTPUT_events3d.dat ]
then
	{ echo 'plot Events3d v0';
	gnuplot plot_events3d_v0.gpi;  }
	{ convert -density 300 +antialias Events3d_v0.eps Events3d_v0.png;
	rm Events3d_v0.eps; }&
	{ echo 'plot Events3d';
	gnuplot plot_events3d.gpi;  }
	{ convert -density 300 +antialias Events3d.eps Events3d.png;
	rm Events3d.eps; }&
else
	if [ -e Events3d.png ]; then rm Events3d.png -v; fi;
	if [ -e Events3d.png ]; then rm Events3d.png -v; fi;
fi


if [ -e ../OUTPUTs/OUTPUT_events_zt_XTANT.dat ]
then
	{ echo 'plot Events_XTANT_eE_zt';
	gnuplot plot_events_XTANT_eE_zt.gpi; } 
	{ convert -density 300 +antialias Events_XTANT_eE_zt.eps Events_XTANT_eE_zt.png;
	rm Events_XTANT_eE_zt.eps; }&
	
	{ echo 'plot Events_XTANT_eN_zt';
	gnuplot plot_events_XTANT_eN_zt.gpi; } 
	{ convert -density 300 +antialias Events_XTANT_eN_zt.eps Events_XTANT_eN_zt.png;
	rm Events_XTANT_eN_zt.eps; }&
else
	if [ -e Events_XTANT_eN_zt.png ]; then rm Events_XTANT_eN_zt.png -v; fi;
	if [ -e Events_XTANT_eE_zt.png ]; then rm Events_XTANT_eE_zt.png -v; fi;
fi

if [ -e ../OUTPUTs/OUTPUT_electrons3d.dat ]
then
	{ echo 'plot electrons 3d';
	gnuplot plot_electrons3d.gpi;  }
	{ convert -density 300 +antialias electrons3d.eps electrons3d.png;
	rm electrons3d.eps; }&
else
	if [ -e electrons3d.png ]; then rm electrons3d.png -v; fi;
fi


echo 'done'; 

