!    XCASCADE-3D software implements Monte Carlo approach to model electron cascades in solids induced by X-ray impact or by an impact of high-energy electrons
!    Copyright (C) 2025 Deutsches Elektronen-Synchrotron DESY, a research centre of the Helmholtz Association.

!    This file is part of XCASCADE-3D software.

!    Authors:
!    Vladimir Lipp <vladimir.lipp@desy.de> (DESY)
!    Nikita Medvedev <medvedev@ipp.cas.cz> (DESY)
!    Beata Ziaja <ziaja@mail.desy.de> (DESY & IFJ)

!    SPDX-FileCopyrightText: 2025 Deutsches Elektronen-Synchrotron DESY
!    SPDX-License-Identifier: AGPL-3.0-only

!    XCASCADE-3D is free software: you can redistribute it and/or modify it under the terms of the Affero GNU General Public License version 3 only, as published by the Free Software Foundation.
!    XCASCADE-3D is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Affero GNU General Public License version 3 for more details.
!    You should have received a copy of the Affero GNU General Public License version 3 along with XCASCADE-3D. If not, see <https://www.gnu.org/licenses/>.

!    For more information about this software, see https://doi.org/10.5281/zenodo.8204314 and https://xm.cfel.de/research/scientific_software/xcascade_amp_xcascade_3d/.

! This module contains definition of an object that will be used in the future to simplify the code structure
module Objects
	implicit none

	type event_type	! Single event in the Monte Carlo simulation, such as, electron scattering, deep shell hole decay or photon absorption. One photon-triggered cascade is simply an array of events. Each cascade is represented by files ./cascades/OUTPUT_cascade*.dat and events are the lines in these files
	!	What we get from XCASCADE
		integer :: koe				! kind of event = photon absorption (1) / electron scattering (2=inelastic,4=elastic) / hole decay (3)
		integer :: nop				! number of acting particle
		real(8) :: time				! time of a particular event
		real(8) :: E_i, E_f, E2, Eh		! [eV] initial energy of particle, final energy of particle after an event, energy of a secondary excited particle (ionization potential was subtracted), kinetic energy of holes
		Integer :: Ne_CB			! number of the excited particle during this event = number of carriers in conduction band after the event
	!	What XCascade3D augments to those data and writes to files:
		real(8) :: r(3)				! coordinates of event
		real(8) :: Etot				! Total energy at the moment of event
		real(8) :: Ech				! Energy inside deep-shell holes at the moment of event
	!	What XCascade3D knows but does not write to files:
		integer :: noec			! current number of elastic collisions at each moment
		Integer :: N_vh			! current number of the valence holes  
	end type

end module Objects
