!    XCASCADE-3D software implements Monte Carlo approach to model electron cascades in solids induced by X-ray impact or by an impact of high-energy electrons
!    Copyright (C) 2025 Deutsches Elektronen-Synchrotron DESY, a research centre of the Helmholtz Association.

!    This file is part of XCASCADE-3D software.

!    Authors:
!    Vladimir Lipp <vladimir.lipp@desy.de> (DESY)
!    Nikita Medvedev <medvedev@ipp.cas.cz> (DESY)
!    Beata Ziaja <ziaja@mail.desy.de> (DESY & IFJ)

!    SPDX-FileCopyrightText: 2025 Deutsches Elektronen-Synchrotron DESY
!    SPDX-License-Identifier: AGPL-3.0-only

!    XCASCADE-3D is free software: you can redistribute it and/or modify it under the terms of the Affero GNU General Public License version 3 only, as published by the Free Software Foundation.
!    XCASCADE-3D is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the Affero GNU General Public License version 3 for more details.
!    You should have received a copy of the Affero GNU General Public License version 3 along with XCASCADE-3D. If not, see <https://www.gnu.org/licenses/>.

!    For more information about this software, see https://doi.org/10.5281/zenodo.8204314 and https://xm.cfel.de/research/scientific_software/xcascade_amp_xcascade_3d/.

! This module contains all the global variables, physical constants and parameters
MODULE Constants
 implicit none

!UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
! Universal constants:
real(8), parameter :: Pi = 3.1415926535897932384626433832795d0            ! Pi
real(8), parameter :: e = 1.602176487d-19         		! Electron charge       [Coulomb]
real(8), parameter :: me = 9.1093821545d-31       		! Electron mass         [kg]
real(8), parameter :: cvel = 299792458.0d0        		! Light velosity        [m/sec]
real(8), parameter :: Mp =1836.1526724780d0*me    	! Proton mass           [kg]
real(8), parameter :: h = 1.05457162853d-34      		! Plank constant        [J*sec]
real(8), parameter :: kb = 11604.0d0              			! Boltzmann constant    [K/eV]
real(8), parameter :: e0 = 8.854187817620d-12     		! Electrical constant   [F/m]
real(8), parameter :: mu0 = 1.2566370614359d-6    	! Magnetic constant     [H*A^-2]
real(8), parameter :: Ry = 13.606d0               			! Rydberg constant      [eV]
real(8), parameter :: a0 = 0.5291772085936d0     		! Bohr radius           [A]
real(8), parameter :: v0 = dsqrt(2.0d0*Ry*e/me)    		! Bohr velosity         [m/s]
real(8), parameter :: alpha = e*e/(h*cvel*4.0d0*Pi*e0)    ! Fine structure constant
!UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU

real(8) :: mee=0.948d0*me
real(8) :: meh=2.227d0*me ! [PHYSICAL REVIEW B78 , 155432, 2008]


END MODULE Constants 