<!--
SPDX-FileCopyrightText: 2025 Deutsches Elektronen-Synchrotron DESY
SPDX-License-Identifier: AGPL-3.0-only
-->

# XCASCADE-3D

## Description
XCASCADE(3D) software models electron cascades in solids triggered by an X-ray impact or by an impact of high-energy electrons (i) on femtosecond timescales, (ii) in atomistic approximation, and (iii) in the non-relativistic energy regime. The code can provide temporal and spatial characteristics of the excited electrons, such as their transient density and energy. For more details, please check the manuals: XCASCADE_manual.odt and XCASCADE-3D_manual.odt.

## Example results
See Ru-12keV.gif

Legend: 

- Yellow circle: place of photon absorption
- Blue circles: places of Auger decays
- Grey asterists: places of electron elastic collisions
- Red empty circles: places of electron inelastic collisions

## Structure of the repository
This repository contains two programs: XCASCADE, which generates temporal information on the electron cascades, and XCASCADE-3D, which augments the results of XCASCADE with spatial information.

## Compiling
Each program should be compiled using "make c=gfo" in its own directory, XCASCADE/ and XCASCADE-3D/. After successful compilations, the executables XCASCADE/xcascade.x and XCASCADE-3D/xcascade3d.x will be generated. For compilation options, please refer to the manuals XCASCADE_manual.odt and XCASCADE-3D_manual.odt.

## Usage
The two codes should be run in the following sequence: 
1) Run xcascade.x inside XCASCADE/ directory. 
2) Move output files "XCASCADE/cascades/OUTPUT_cascade*.dat" generated by XCASCADE to the folder XCASCADE-3D/cascades/. 
3) Run xcascade3d.x inside XCASCADE-3D/ directory. 

See XCASCADE_manual.odt and XCASCADE-3D_manual.odt for information about input and output files.

## Authors and acknowledgment
The software was written at DESY, Hamburg, Germany by Vladimir Lipp, Nikita Medvedev, and Beata Ziaja.

## License
XCASCADE-3D is a free and open source software as defined by the AGPL-3.0-only license.

## Contributions and support
We do not actively accept contributions from third parties or provide any support for the software.

## Citation
If you publish results obtained with XCASCADE alone, please cite the following references:

	1. V. Lipp, B. Ziaja, and N. Medvedev, XCASCADE (3D) (2023), doi:10.5281/zenodo.8204314.

	2. N. Medvedev, Appl. Phys. B 118, 417 (2015); Erratum Appl. Phys. B 125, 80 (2019).

	3. B. Ziaja, D. van der Spoel, A. Szoeke, J. Hajdu, Phys. Rev. B 64, 214104 (2001).

If you publish results obtained with XCASCADE-3D, please cite the following references:

	1. V. Lipp, B. Ziaja, and N. Medvedev, XCASCADE (3D) (2023), doi:10.5281/zenodo.8204314.

	2. V. Lipp, N. Medvedev, B. Ziaja, Proc. of SPIE 10239, 102360H (2017).

	3. V. Lipp, I. Milov, N. Medvedev, J. Sync. Rad. 29, 323 (2022).